<?php

require_once "common.php";
session_start();

function startOpenIDAuth($returnFile) {
	$_GET['action'] = 'verify';
	$_GET['openid_identifier'] = 'http://yo.rediris.es/';
	
    $openid = $_GET['openid_identifier'];
    $consumer = getConsumer();

    // Begin the OpenID authentication process.
    $auth_request = $consumer->begin($openid);

    // No auth request means we can't begin OpenID.
    if (!$auth_request) {
		$msg_error = "Authentication error; not a valid OpenID.";
        header("Location: ".$returnFile."?openid_msg_error=".base64_encode($msg_error);
        exit();
    }

    // Redirect the user to the OpenID server for authentication.
    // Store the token for this authentication so we can verify the
    // response.

    // For OpenID 1, send a redirect.  For OpenID 2, use a Javascript
    // form to send a POST request to the server.
    if ($auth_request->shouldSendRedirect()) {
        $redirect_url = $auth_request->redirectURL(getTrustRoot(),
                                                   getReturnTo($returnFile));

        // If the redirect URL can't be built, display an error
        // message.
        if (Auth_OpenID::isFailure($redirect_url)) {
        	$msg_error = "Could not redirect to server: " . $redirect_url->message;
	        header("Location: ".$returnFile."?openid_msg_error=".base64_encode($msg_error);
            exit();
        } else {
            // Send redirect.
            header("Location: ".$redirect_url);
            exit();
        }
    } else {
        // Generate form markup and render it.
        $form_id = 'openid_message';
        $form_html = $auth_request->htmlMarkup(getTrustRoot(), getReturnTo($returnFile),
                                               false, array('id' => $form_id));

        // Display an error if the form markup couldn't be generated;
        // otherwise, render the HTML.
        if (Auth_OpenID::isFailure($form_html)) {
            $msg_error = "Could not redirect to server: " . $form_html->message;
	        header("Location: ".$returnFile."?openid_msg_error=".base64_encode($msg_error);
            exit();
        } else {
            echo $form_html;
        }
    }
}

?>